<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'category_id', 'sub_category_id', 'free_shipping', 'is_drafted', 'price');

    public function tags()
    {
        return $this->belongsToMany('App\Models\Tag');
    }

    public function subCategory()
    {
        return $this->belongsTo('App\Models\Category', 'sub_category_id');
    }

    public function discounts()
    {
        return $this->belongsToMany('App\Models\Discount');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function prices()
    {
        return $this->hasMany('ProductPrice');
    }

}